#!/bin/sh
# configversion: a5cd73350a63875311280e53a64cc888
# SPDX-License-Identifier: AGPL-3.0-only
# Copyright 2022 Sxmo Contributors

# include common definitions
# shellcheck source=scripts/core/sxmo_common.sh
. sxmo_common.sh

# Create xdg user directories, such as ~/Pictures
xdg-user-dirs-update

sxmo_daemons.sh start daemon_manager superd -v

# let time to superd to start correctly
while ! superctl status > /dev/null 2>&1; do
	sleep 0.5
done

# Periodically update some status bar components
sxmo_hook_statusbar.sh all
sxmo_daemons.sh start statusbar_periodics sxmo_run_aligned.sh 60 \
	sxmo_hook_statusbar.sh periodics

# mako/dunst are required for warnings.
# load some other little things here too.
case "$SXMO_WM" in
	sway)
		superctl start mako
		superctl start sxmo_wob
		superctl start sxmo_menumode_toggler
		superctl start bonsaid
		swaymsg output '*' bg "$SXMO_BG_IMG" fill
		;;
	dwm)
		superctl start dunst

		# Auto hide cursor with touchscreen, Show it with a mouse
		if command -v "unclutter-xfixes" > /dev/null; then
			set -- unclutter-xfixes
		else
			set -- unclutter
		fi
		superctl start "$1"

		superctl start autocutsel
		superctl start autocutsel-primary
		superctl start sxmo-x11-status
		superctl start bonsaid
		[ -n "$SXMO_MONITOR" ] && xrandr --output "$SXMO_MONITOR" --primary
		feh --bg-fill "$SXMO_BG_IMG"
		;;
esac

# To setup initial lock state
sxmo_hook_unlock.sh

# Turn on auto-suspend
if [ -w "/sys/power/wakeup_count" ] && [ -f "/sys/power/wake_lock" ]; then
	superctl start sxmo_autosuspend
fi

# Turn on lisgd
superctl start sxmo_hook_lisgd

if [ "$(command -v ModemManager)" ]; then
	# Turn on the dbus-monitors for modem-related tasks
	superctl start sxmo_modemmonitor

	# place a wakelock for 120s to allow the modem to fully warm up (eg25 +
	# elogind/systemd would do this for us, but we don't use those.)
	sxmo_wakelock.sh lock modem_warming_up 120s
fi

# Start the desktop widget (e.g. clock)
superctl start sxmo_conky

# Monitor the battery
superctl start sxmo_battery_monitor

# It watch network changes and update the status bar icon by example
superctl start sxmo_networkmonitor

# The daemon that display notifications popup messages
superctl start sxmo_notificationmonitor

# monitor for headphone for statusbar
superctl start sxmo_soundmonitor

# Play a funky startup tune if you want (disabled by default)
#mpv --quiet --no-video ~/welcome.ogg &

# add some warnings if things are not setup correctly
deviceprofile="$(command -v "sxmo_deviceprofile_$SXMO_DEVICE_NAME.sh")"

[ -f "$deviceprofile" ] || sxmo_notify_user.sh --urgency=critical \
	"No deviceprofile found $SXMO_DEVICE_NAME. See: https://sxmo.org/deviceprofile"

sxmo_migrate.sh state || sxmo_notify_user.sh --urgency=critical \
	"Config needs migration" "$? file(s) in your sxmo configuration are out of date and disabled - using defaults until you migrate (run sxmo_migrate.sh)"
