#!/bin/sh

# shellcheck source=scripts/core/sxmo_common.sh
. sxmo_common.sh

set -e

setup_audio() {
	enable_call_audio_mode
	disable_speaker
	unmute_mic

	# TODO: callaudiocli should error if it doesn't set these
	# Since we set -e this script will error if these aren't true
	is_call_audio_mode
	is_disabled_speaker
	is_unmuted_mic
}

reset_audio() {
	disable_call_audio_mode
	enable_speaker
	mute_mic

	# TODO: callaudiocli should error if it doesn't set these
	# Since we set -e this script will error if these aren't true
	is_default_audio_mode
	is_enabled_speaker
	is_muted_mic
}

is_muted_mic() {
	callaudiocli -S | grep -q "Mic muted: CALL_AUDIO_MIC_OFF"
}

is_unmuted_mic() {
	callaudiocli -S | grep -q "Mic muted: CALL_AUDIO_MIC_ON"
}

mute_mic() {
	callaudiocli -u 1
}

unmute_mic() {
	callaudiocli -u 0
}

is_call_audio_mode() {
	callaudiocli -S | grep -q "Selected mode: CALL_AUDIO_MODE_CALL"
}

is_default_audio_mode() {
	callaudiocli -S | grep -q "Selected mode: CALL_AUDIO_MODE_DEFAULT"
}

enable_call_audio_mode() {
	callaudiocli -m 1
}

disable_call_audio_mode() {
	callaudiocli -m 0
}

is_enabled_speaker() {
	callaudiocli -S | grep -q "Speaker enabled: CALL_AUDIO_SPEAKER_ON"
}

is_disabled_speaker() {
	callaudiocli -S | grep -q "Speaker enabled: CALL_AUDIO_SPEAKER_OFF"
}

enable_speaker() {
	callaudiocli -s 1
}

disable_speaker() {
	callaudiocli -s 0
}

"$@"
