#!/bin/sh
# configversion: ae5192e49618b88d4cd29267c9fb872f
# SPDX-License-Identifier: AGPL-3.0-only
# Copyright 2022 Sxmo Contributors

# This hook displays the sms log for a numbers passed as $1

# include common definitions
# shellcheck source=scripts/core/sxmo_common.sh
. sxmo_common.sh

NUMBER="$1"
CONTACTNAME="$(sxmo_contacts.sh | grep ": ${NUMBER}$" | cut -d: -f1)"
[ "???" = "$CONTACTNAME" ] && CONTACTNAME="$CONTACTNAME ($NUMBER)"

TERMNAME="$NUMBER SMS" sxmo_terminal.sh sh -c "tail -n9999 -f \"$SXMO_LOGDIR/$NUMBER/sms.txt\" | sed \"s|$NUMBER|$CONTACTNAME|g\""
